import {
  StateNode
} from "@tldraw/editor";
class Pointing extends StateNode {
  static id = "pointing";
  onEnter = () => {
    const zoomLevel = this.editor.getZoomLevel();
    const currentPageShapesSorted = this.editor.getCurrentPageShapesSorted();
    const {
      inputs: { currentPagePoint }
    } = this.editor;
    const erasing = /* @__PURE__ */ new Set();
    const initialSize = erasing.size;
    for (let n = currentPageShapesSorted.length, i = n - 1; i >= 0; i--) {
      const shape = currentPageShapesSorted[i];
      if (this.editor.isShapeOrAncestorLocked(shape) || this.editor.isShapeOfType(shape, "group")) {
        continue;
      }
      if (this.editor.isPointInShape(shape, currentPagePoint, {
        hitInside: false,
        margin: this.editor.options.hitTestMargin / zoomLevel
      })) {
        const hitShape = this.editor.getOutermostSelectableShape(shape);
        if (this.editor.isShapeOfType(hitShape, "frame") && erasing.size > initialSize) {
          break;
        }
        erasing.add(hitShape.id);
      }
    }
    this.editor.setErasingShapes([...erasing]);
  };
  onLongPress = (info) => {
    this.startErasing(info);
  };
  onPointerMove = (info) => {
    if (this.editor.inputs.isDragging) {
      this.startErasing(info);
    }
  };
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.complete();
  };
  onInterrupt = () => {
    this.cancel();
  };
  startErasing(info) {
    this.parent.transition("erasing", info);
  }
  complete() {
    const erasingShapeIds = this.editor.getErasingShapeIds();
    if (erasingShapeIds.length) {
      this.editor.mark("erase end");
      this.editor.deleteShapes(erasingShapeIds);
    }
    this.editor.setErasingShapes([]);
    this.parent.transition("idle");
  }
  cancel() {
    this.editor.setErasingShapes([]);
    this.parent.transition("idle");
  }
}
export {
  Pointing
};
//# sourceMappingURL=Pointing.mjs.map
